Ext.data.JsonP.sol_common_ix_services_ChildrenDataWithMaps({"tagname":"class","name":"sol.common.ix.services.ChildrenDataWithMaps","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.services.ChildrenDataWithMaps.js","href":"sol.common.ix.services.ChildrenDataWithMaps.html#sol-common-ix-services-ChildrenDataWithMaps"}],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.ServiceBase","mixins":[],"requires":[],"uses":[],"members":[{"name":"objId","tagname":"cfg","owner":"sol.common.ix.ServiceBase","id":"cfg-objId","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"sordKeys","tagname":"cfg","owner":"sol.common.ix.services.ChildrenDataWithMaps","id":"cfg-sordKeys","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"collectorVersion","tagname":"property","owner":"sol.common.ix.services.ChildrenDataWithMaps","id":"property-collectorVersion","meta":{"private":true}},{"name":"data","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-data","meta":{}},{"name":"docMasks","tagname":"property","owner":"sol.common.ix.services.ChildrenDataWithMaps","id":"property-docMasks","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-logger","meta":{"protected":true}},{"name":"totalCount","tagname":"property","owner":"sol.common.ix.services.ChildrenDataWithMaps","id":"property-totalCount","meta":{}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"addDocMaskData","tagname":"method","owner":"sol.common.ix.services.ChildrenDataWithMaps","id":"method-addDocMaskData","meta":{"private":true}},{"name":"addMapKeys","tagname":"method","owner":"sol.common.ix.services.ChildrenDataWithMaps","id":"method-addMapKeys","meta":{"private":true}},{"name":"buildDocMaskData","tagname":"method","owner":"sol.common.ix.services.ChildrenDataWithMaps","id":"method-buildDocMaskData","meta":{"private":true}},{"name":"checkMandatoryProperties","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-checkMandatoryProperties","meta":{"protected":true}},{"name":"collectChildren","tagname":"method","owner":"sol.common.ix.services.ChildrenDataWithMaps","id":"method-collectChildren","meta":{"private":true}},{"name":"containsClassName","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-containsClassName","meta":{}},{"name":"execute","tagname":"method","owner":"sol.common.ix.services.ChildrenDataWithMaps","id":"method-execute","meta":{}},{"name":"getSord","tagname":"method","owner":"sol.common.ix.services.ChildrenDataWithMaps","id":"method-getSord","meta":{"private":true}},{"name":"getTypeConstants","tagname":"method","owner":"sol.common.ix.services.ChildrenDataWithMaps","id":"method-getTypeConstants","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-initialize","meta":{"private":true}},{"name":"prefillMetadata","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-prefillMetadata","meta":{"protected":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-process","meta":{"abstract":true}},{"name":"RF_sol_common_services_ChildrenDataWithMaps","tagname":"method","owner":"sol.common.ix.services.ChildrenDataWithMaps","id":"static-method-RF_sol_common_services_ChildrenDataWithMaps","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.services.ChildrenDataWithMaps","short_doc":"Collects all child sords for a given parent with all objKeys, all mapFields and the maskFieldnames of all objKeys. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.ServiceBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='docClass'>sol.common.ix.ServiceBase</a><div class='subclass '><strong>sol.common.ix.services.ChildrenDataWithMaps</strong></div></div></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.services.ChildrenDataWithMaps.html#sol-common-ix-services-ChildrenDataWithMaps' target='_blank'>sol.common.ix.services.ChildrenDataWithMaps.js</a></div></pre><div class='doc-contents'><p>Collects all child sords for a given parent with all objKeys, all mapFields and the maskFieldnames of all objKeys.</p>\n\n<h1>Example</h1>\n\n<pre><code>var result = <a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_common_services_ChildrenDataWithMaps\", {  \n   \"parentId\": \"ARCPATH[(E10E1000-E100-E100-E100-E10E10E10E00)]:/Business Solutions/common/Configuration\",\n   \"sordKeys\": [\"name\", \"id\", \"maskName\", \"guid\", \"parentId\", \"type\", \"desc\"]\n});\n</code></pre>\n\n<h1>Result</h1>\n\n<p>{\n  \"sord\": {\n     \"name\": \"Configuration\",\n     \"id\": \"1838\",\n     \"maskName\": \"Folder\",\n     \"guid\": \"(5EE11DB8-CBE5-F0F6-4C8C-F9D292AEDD79)\",\n     \"parentId\": \"1788\",\n     \"type\": \"47\",\n     \"desc\": \"\"\n   },\n   \"sords\": [\n     {\n       \"name\": \"as.config\",\n       \"id\": \"1841\",\n       \"maskName\": \"ELO Business Solution Configuration\",\n       \"guid\": \"(89A52C86-6DF6-4EB6-1A7A-F9E84A016C0D)\",\n       \"parentId\": \"1838\",\n       \"type\": \"254\",\n       \"desc\": \"\",\n       \"mapKeys\": {},\n       \"objKeys\": {\n         \"BS_CONFIG_NAME\": \"ELO AS settings\",\n         \"BS_CONFIG_VERSION\": \"1.0\",\n         \"BS_CONFIG_TYPE\": \"\",\n         \"SOL_TYPE\": \"\",\n         \"ELO_FNAME\": \"as.config.json\"\n       }\n     },\n     {\n        ...\n     }\n   ],\n   \"masks\": {\n     \"ELO Business Solution Configuration\": {\n       \"fields\": {\n         \"BS_CONFIG_NAME\": {\n           \"name\": \"Name\",\n           \"type\": \"TEXT\"\n         },\n         \"BS_CONFIG_VERSION\": {\n           \"name\": \"Version\",\n           \"type\": \"TEXT\"\n         },\n         \"BS_CONFIG_TYPE\": {\n           \"name\": \"Type\",\n           \"type\": \"TEXT\"\n         },\n         \"SOL_TYPE\": {\n           \"name\": \"Solution object type\",\n           \"type\": \"TEXT\"\n         }\n       }\n     }\n   }\n }</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-objId' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-sordKeys' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataWithMaps'>sol.common.ix.services.ChildrenDataWithMaps</span><br/><a href='source/sol.common.ix.services.ChildrenDataWithMaps.html#sol-common-ix-services-ChildrenDataWithMaps-cfg-sordKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataWithMaps-cfg-sordKeys' class='name expandable'>sordKeys</a> : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>List of required sord keys. ...</div><div class='long'><p>List of required sord keys.</p>\n\n<p>This only returns the given sord keys. This is required in order to limit traffic for not required keys.</p>\n\n<pre><code>sordKeys: [\"id\", \"guid\", \"name\", \"desc\"],\n</code></pre>\n<p>Defaults to: <code>[&quot;id&quot;, &quot;guid&quot;, &quot;name&quot;, &quot;desc&quot;]</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-collectorVersion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataWithMaps'>sol.common.ix.services.ChildrenDataWithMaps</span><br/><a href='source/sol.common.ix.services.ChildrenDataWithMaps.html#sol-common-ix-services-ChildrenDataWithMaps-property-collectorVersion' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataWithMaps-property-collectorVersion' class='name expandable'>collectorVersion</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;1.00.000&quot;</code></p></div></div></div><div id='property-data' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-data' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-data' class='name expandable'>data</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div><div class='long'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div></div></div><div id='property-docMasks' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataWithMaps'>sol.common.ix.services.ChildrenDataWithMaps</span><br/><a href='source/sol.common.ix.services.ChildrenDataWithMaps.html#sol-common-ix-services-ChildrenDataWithMaps-property-docMasks' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataWithMaps-property-docMasks' class='name expandable'>docMasks</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the service</p>\n</div><div class='long'><p>The logger for the service</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div><div id='property-totalCount' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataWithMaps'>sol.common.ix.services.ChildrenDataWithMaps</span><br/><a href='source/sol.common.ix.services.ChildrenDataWithMaps.html#sol-common-ix-services-ChildrenDataWithMaps-property-totalCount' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataWithMaps-property-totalCount' class='name expandable'>totalCount</a> : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>The search is terminated if this number of objects is found. ...</div><div class='long'><p>The search is terminated if this number of objects is found. If the number of results should not be constrained,\nset this value to 232-1 = 2147483647 (maximum value of a positive 32bit integer minus 1).</p>\n\n<p>Please note that collecting huge amounts of data might lead to performance issues.</p>\n<p>Defaults to: <code>10000</code></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-addDocMaskData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataWithMaps'>sol.common.ix.services.ChildrenDataWithMaps</span><br/><a href='source/sol.common.ix.services.ChildrenDataWithMaps.html#sol-common-ix-services-ChildrenDataWithMaps-method-addDocMaskData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataWithMaps-method-addDocMaskData' class='name expandable'>addDocMaskData</a>( <span class='pre'>maskName</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Adds document mask data ...</div><div class='long'><p>Adds document mask data</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>maskName</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-addMapKeys' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataWithMaps'>sol.common.ix.services.ChildrenDataWithMaps</span><br/><a href='source/sol.common.ix.services.ChildrenDataWithMaps.html#sol-common-ix-services-ChildrenDataWithMaps-method-addMapKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataWithMaps-method-addMapKeys' class='name expandable'>addMapKeys</a>( <span class='pre'>resultObj</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>helpers for collectChildren ...</div><div class='long'><p>helpers for collectChildren</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>resultObj</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-buildDocMaskData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataWithMaps'>sol.common.ix.services.ChildrenDataWithMaps</span><br/><a href='source/sol.common.ix.services.ChildrenDataWithMaps.html#sol-common-ix-services-ChildrenDataWithMaps-method-buildDocMaskData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataWithMaps-method-buildDocMaskData' class='name expandable'>buildDocMaskData</a>( <span class='pre'>docMaskName</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Builds the document mask data ...</div><div class='long'><p>Builds the document mask data</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>docMaskName</span> : String<div class='sub-desc'><p>Document mask name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-checkMandatoryProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-checkMandatoryProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-checkMandatoryProperties' class='name expandable'>checkMandatoryProperties</a>( <span class='pre'></span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Checks if all mandatory properties have been set. ...</div><div class='long'><p>Checks if all mandatory properties have been set.</p>\n</div></div></div><div id='method-collectChildren' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataWithMaps'>sol.common.ix.services.ChildrenDataWithMaps</span><br/><a href='source/sol.common.ix.services.ChildrenDataWithMaps.html#sol-common-ix-services-ChildrenDataWithMaps-method-collectChildren' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataWithMaps-method-collectChildren' class='name expandable'>collectChildren</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-containsClassName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-containsClassName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-containsClassName' class='name expandable'>containsClassName</a>( <span class='pre'>classNames</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether an array contains the class name ...</div><div class='long'><p>Checks wether an array contains the class name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>classNames</span> : Array<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-execute' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataWithMaps'>sol.common.ix.services.ChildrenDataWithMaps</span><br/><a href='source/sol.common.ix.services.ChildrenDataWithMaps.html#sol-common-ix-services-ChildrenDataWithMaps-method-execute' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataWithMaps-method-execute' class='name expandable'>execute</a>( <span class='pre'></span> ) : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>Starts the collection of the desired data ...</div><div class='long'><p>Starts the collection of the desired data</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataWithMaps'>sol.common.ix.services.ChildrenDataWithMaps</span><br/><a href='source/sol.common.ix.services.ChildrenDataWithMaps.html#sol-common-ix-services-ChildrenDataWithMaps-method-getSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataWithMaps-method-getSord' class='name expandable'>getSord</a>( <span class='pre'>objId</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>helpers for collectChildren ...</div><div class='long'><p>helpers for collectChildren</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getTypeConstants' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataWithMaps'>sol.common.ix.services.ChildrenDataWithMaps</span><br/><a href='source/sol.common.ix.services.ChildrenDataWithMaps.html#sol-common-ix-services-ChildrenDataWithMaps-method-getTypeConstants' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataWithMaps-method-getTypeConstants' class='name expandable'>getTypeConstants</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-prefillMetadata' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-prefillMetadata' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-prefillMetadata' class='name expandable'>prefillMetadata</a>( <span class='pre'>objId</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Initializes the metadata of an element (defined by objId) from the internal data object. ...</div><div class='long'><p>Initializes the metadata of an element (defined by <code>objId</code>) from the internal <code>data</code> object.</p>\n\n<p>The <code>data</code> property has to be in a specific <a href=\"#!/api/sol.common.ix.ServiceBase-property-data\" rel=\"sol.common.ix.ServiceBase-property-data\" class=\"docClass\">form</a>.\nIf there is no data object no prefilling will be performed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-process' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"><span class='abstract' >abstract</span></span></div><div class='description'><div class='short'>Implementation of services' process. ...</div><div class='long'><p>Implementation of services' process. This function must be implemented by the child class and should contain the logic of the function module.</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_common_services_ChildrenDataWithMaps' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataWithMaps'>sol.common.ix.services.ChildrenDataWithMaps</span><br/><a href='source/sol.common.ix.services.ChildrenDataWithMaps.html#sol-common-ix-services-ChildrenDataWithMaps-static-method-RF_sol_common_services_ChildrenDataWithMaps' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataWithMaps-static-method-RF_sol_common_services_ChildrenDataWithMaps' class='name expandable'>RF_sol_common_services_ChildrenDataWithMaps</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{}});